<?php
// Navbar configuration
$logoPath = "LOGO1.png";
$logoAlt = "Sistem Guru Kelas SD";
$logoWidth = "150px"; // Consistent size for all pages
?>
<!-- Navigation -->
<nav class="bg-white shadow-lg">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between items-center" style="height: 90px;">
            <div class="flex items-center">
                <a href="dashboard.php" class="flex items-center">
                    <img src="<?= $logoPath ?>" alt="<?= $logoAlt ?>" class="object-contain" style="width: <?= $logoWidth ?>;">
                </a>
            </div>
            <div class="flex items-center space-x-4">
                <?php if (isset($currentUser)): ?>
                    <span class="text-gray-700">Kelas: <?= htmlspecialchars($currentUser['nama_kelas'] ?? 'Belum ditentukan') ?></span>
                    <div class="relative">
                        <a href="profil_guru.php">
                            <button class="flex items-center space-x-2 text-gray-700 hover:text-indigo-600">
                                <i class="fas fa-user-circle text-xl"></i>
                                <span><?= htmlspecialchars($currentUser['nama_guru']) ?></span>
                            </button>
                        </a>
                    </div>
                <?php endif; ?>
                <?php if (basename($_SERVER['PHP_SELF']) !== 'login.php'): ?>
                    <a href="logout.php" class="text-red-600 hover:text-red-800">
                        <i class="fas fa-sign-out-alt"></i>
                    </a>
                <?php endif; ?>
            </div>
        </div>
    </div>
</nav>
