<?php
require_once 'config/session.php';
require_once 'config/database.php';
checkLogin();

$database = new Database();
$conn = $database->getConnection();

// Get student ID from URL
$id_siswa = isset($_GET['id']) ? $_GET['id'] : die('ERROR: Student ID not found.');

// Fetch student details
$query = "SELECT * FROM siswa WHERE id_siswa = :id_siswa";
$stmt = $conn->prepare($query);
$stmt->bindParam(':id_siswa', $id_siswa);
$stmt->execute();
$student = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$student) {
    die('ERROR: Student not found.');
}

// Handle form submission
$message = '';
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['update_student'])) {
        $nis = $_POST['nis'];
        $nama_siswa = $_POST['nama_siswa'];
        $jenis_kelamin = $_POST['jenis_kelamin'];
        $tanggal_lahir = $_POST['tanggal_lahir'];
        $alamat = $_POST['alamat'];
        $nama_ortu = $_POST['nama_ortu'];
        $no_telp_ortu = $_POST['no_telp_ortu'];
        
        $query = "UPDATE siswa SET 
                  nis = :nis, 
                  nama_siswa = :nama_siswa, 
                  jenis_kelamin = :jenis_kelamin, 
                  tanggal_lahir = :tanggal_lahir, 
                  alamat = :alamat, 
                  nama_ortu = :nama_ortu, 
                  no_telp_ortu = :no_telp_ortu 
                  WHERE id_siswa = :id_siswa";
        
        $stmt = $conn->prepare($query);
        $stmt->bindParam(':nis', $nis);
        $stmt->bindParam(':nama_siswa', $nama_siswa);
        $stmt->bindParam(':jenis_kelamin', $jenis_kelamin);
        $stmt->bindParam(':tanggal_lahir', $tanggal_lahir);
        $stmt->bindParam(':alamat', $alamat);
        $stmt->bindParam(':nama_ortu', $nama_ortu);
        $stmt->bindParam(':no_telp_ortu', $no_telp_ortu);
        $stmt->bindParam(':id_siswa', $id_siswa);
        
        if ($stmt->execute()) {
            $message = "Data siswa berhasil diperbarui!";
            header("Location: detail_siswa.php?id=" . $id_siswa . "&success=1");
            exit();
        } else {
            $message = "Gagal memperbarui data siswa!";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Siswa - SIMAGU</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body class="bg-gray-50">
    <?php require_once 'includes/navbar.php'; ?>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <!-- Header -->
        <div class="flex justify-between items-center mb-6">
            <h1 class="text-3xl font-bold text-gray-800">Edit Data Siswa</h1>
            <a href="detail_siswa.php?id=<?= $student['id_siswa'] ?>" class="bg-gray-600 text-white px-4 py-2 rounded-lg hover:bg-gray-700 transition">
                <i class="fas fa-arrow-left mr-2"></i>Kembali
            </a>
        </div>

        <!-- Success Message -->
        <?php if ($message): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
            <i class="fas fa-check-circle mr-2"></i><?= $message ?>
        </div>
        <?php endif; ?>

        <!-- Edit Form -->
        <div class="bg-white rounded-lg shadow-md p-6">
            <form method="POST" class="space-y-6">
                <input type="hidden" name="update_student" value="1">
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-sm font-medium text-gray-700">NIS</label>
                        <input type="text" name="nis" value="<?= htmlspecialchars($student['nis']) ?>" required 
                               class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Nama Siswa</label>
                        <input type="text" name="nama_siswa" value="<?= htmlspecialchars($student['nama_siswa']) ?>" required 
                               class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Jenis Kelamin</label>
                        <select name="jenis_kelamin" required 
                                class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            <option value="L" <?= $student['jenis_kelamin'] == 'L' ? 'selected' : '' ?>>Laki-laki</option>
                            <option value="P" <?= $student['jenis_kelamin'] == 'P' ? 'selected' : '' ?>>Perempuan</option>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Tanggal Lahir</label>
                        <input type="date" name="tanggal_lahir" value="<?= $student['tanggal_lahir'] ?>" required 
                               class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>
                    <div class="md:col-span-2">
                        <label class="block text-sm font-medium text-gray-700">Alamat</label>
                        <textarea name="alamat" rows="3" 
                                  class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"><?= htmlspecialchars($student['alamat']) ?></textarea>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Nama Orang Tua</label>
                        <input type="text" name="nama_ortu" value="<?= htmlspecialchars($student['nama_ortu']) ?>" 
                               class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">No. Telp Orang Tua</label>
                        <input type="text" name="no_telp_ortu" value="<?= htmlspecialchars($student['no_telp_ortu']) ?>" 
                               class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>
                </div>
                
                <div class="flex justify-end space-x-3 pt-4">
                    <a href="detail_siswa.php?id=<?= $student['id_siswa'] ?>" class="px-4 py-2 bg-gray-300 text-gray-700 rounded-md hover:bg-gray-400">
                        Batal
                    </a>
                    <button type="submit" class="px-4 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700">
                        <i class="fas fa-save mr-2"></i>Simpan Perubahan
                    </button>
                </div>
            </form>
        </div>
    </div>
</body>
</html>
