<?php
require_once 'config/session.php';
require_once 'config/database.php';
checkLogin();

$database = new Database();
$conn = $database->getConnection();
$currentUser = getCurrentUser();

// Get dashboard statistics
$stats = [];

// Count students in teacher's class
if ($currentUser['id_kelas']) {
    $query = "SELECT COUNT(*) as total_siswa FROM siswa WHERE id_kelas = :id_kelas AND status = 'aktif'";
    $stmt = $conn->prepare($query);
    $stmt->bindParam(':id_kelas', $currentUser['id_kelas']);
    $stmt->execute();
    $stats['total_siswa'] = $stmt->fetchColumn();
    
    // Get today's attendance
    $today = date('Y-m-d');
    $query = "SELECT COUNT(*) FROM absensi WHERE id_kelas = :id_kelas AND tanggal = :tanggal";
    $stmt = $conn->prepare($query);
    $stmt->bindParam(':id_kelas', $currentUser['id_kelas']);
    $stmt->bindParam(':tanggal', $today);
    $stmt->execute();
    $stats['absensi_today'] = $stmt->fetchColumn();
    
    // Get active assignments
    $query = "SELECT COUNT(*) FROM tugas WHERE id_kelas = :id_kelas AND tanggal_selesai >= CURDATE()";
    $stmt = $conn->prepare($query);
    $stmt->bindParam(':id_kelas', $currentUser['id_kelas']);
    $stmt->execute();
    $stats['tugas_aktif'] = $stmt->fetchColumn();
} else {
    $stats['total_siswa'] = 0;
    $stats['absensi_today'] = 0;
    $stats['tugas_aktif'] = 0;
}

// Get recent students
$recentStudents = [];
if ($currentUser['id_kelas']) {
    $query = "SELECT * FROM siswa WHERE id_kelas = :id_kelas AND status = 'aktif' 
              ORDER BY created_at DESC LIMIT 5";
    $stmt = $conn->prepare($query);
    $stmt->bindParam(':id_kelas', $currentUser['id_kelas']);
    $stmt->execute();
    $recentStudents = $stmt->fetchAll(PDO::FETCH_ASSOC);
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - SIMAGU</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body class="bg-gray-50">
    <!-- Navigation -->
    <?php require_once 'includes/navbar.php'; ?>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <!-- Welcome Section -->
        <div class="bg-white rounded-lg shadow-md p-6 mb-8">
            <h1 class="text-2xl font-bold text-gray-800 mb-2">Selamat Datang, <?= htmlspecialchars($currentUser['nama_guru']) ?>!</h1>
            <p class="text-gray-600">Kelola kelas Anda dengan mudah dan efisien</p>
        </div>

        <!-- Statistics Cards -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
            <div class="bg-white rounded-lg shadow-md p-6">
                <div class="flex items-center">
                    <div class="p-3 rounded-full bg-blue-100 text-blue-600">
                        <i class="fas fa-users text-2xl"></i>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-600">Total Siswa</p>
                        <p class="text-2xl font-bold text-gray-900"><?= $stats['total_siswa'] ?></p>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-lg shadow-md p-6">
                <div class="flex items-center">
                    <div class="p-3 rounded-full bg-green-100 text-green-600">
                        <i class="fas fa-calendar-check text-2xl"></i>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-600">Absensi Hari Ini</p>
                        <p class="text-2xl font-bold text-gray-900"><?= $stats['absensi_today'] ?></p>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-lg shadow-md p-6">
                <div class="flex items-center">
                    <div class="p-3 rounded-full bg-purple-100 text-purple-600">
                        <i class="fas fa-tasks text-2xl"></i>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-600">Tugas Aktif</p>
                        <p class="text-2xl font-bold text-gray-900"><?= $stats['tugas_aktif'] ?></p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
            <a href="siswa.php" class="bg-white rounded-lg shadow-md p-6 hover:shadow-lg transition duration-200">
                <div class="text-center">
                    <i class="fas fa-user-graduate text-4xl text-blue-600 mb-3"></i>
                    <h3 class="text-lg font-semibold text-gray-800">Daftar Siswa</h3>
                    <p class="text-sm text-gray-600">Kelola data siswa</p>
                </div>
            </a>

            <a href="absensi.php" class="bg-white rounded-lg shadow-md p-6 hover:shadow-lg transition duration-200">
                <div class="text-center">
                    <i class="fas fa-clipboard-list text-4xl text-green-600 mb-3"></i>
                    <h3 class="text-lg font-semibold text-gray-800">Absensi</h3>
                    <p class="text-sm text-gray-600">Catat kehadiran siswa</p>
                </div>
            </a>

            <a href="tugas.php" class="bg-white rounded-lg shadow-md p-6 hover:shadow-lg transition duration-200">
                <div class="text-center">
                    <i class="fas fa-book text-4xl text-purple-600 mb-3"></i>
                    <h3 class="text-lg font-semibold text-gray-800">Tugas</h3>
                    <p class="text-sm text-gray-600">Kelola tugas siswa</p>
                </div>
            </a>

            <a href="nilai.php" class="bg-white rounded-lg shadow-md p-6 hover:shadow-lg transition duration-200">
                <div class="text-center">
<i class="fas fa-star text-4xl text-orange-500"></i>
                    <h3 class="text-lg font-semibold text-gray-800">Nilai Tugas</h3>
                    <p class="text-sm text-gray-600">Rekap nilai Tugas siswa</p>
                </div>
            </a>
            
            <a href="rekap_absensi.php" class="bg-white rounded-lg shadow-md p-6 hover:shadow-lg transition duration-200">
                <div class="text-center">
<i class="fas fa-user-check text-4xl text-green-600"></i>
                    <h3 class="text-lg font-semibold text-gray-800">Rekap Kehadiran</h3>
                    <p class="text-sm text-gray-600">Rekap Kehadiran siswa</p>
                </div>
            </a>

              <a href="nilai_komponen.php" class="bg-white rounded-lg shadow-md p-6 hover:shadow-lg transition duration-200">
                <div class="text-center">
<i class="fas fa-file-alt text-4xl text-yellow-600"></i>
                    <h3 class="text-lg font-semibold text-gray-800">Nilai Harian</h3>
                    <p class="text-sm text-gray-600">Nilai Harian siswa</p>
                </div>
            </a>

             <a href="rekap_nilai_komponen.php" class="bg-white rounded-lg shadow-md p-6 hover:shadow-lg transition duration-200">
                <div class="text-center">
                    <i class="fas fa-chart-line text-4xl text-red-600 mb-3"></i>
                    <h3 class="text-lg font-semibold text-gray-800">Rekap Nilai Harian</h3>
                    <p class="text-sm text-gray-600">Rekap Nilai Harian siswa</p>
                </div>
            </a>
        </div>

        <!-- Recent Students -->
        <?php if (!empty($recentStudents)): ?>
        <div class="bg-white rounded-lg shadow-md p-6">
            <h2 class="text-xl font-bold text-gray-800 mb-4">Siswa Baru</h2>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead>
                        <tr>
                            <th class="px-6 py-3 bg-gray-50 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">NIS</th>
                            <th class="px-6 py-3 bg-gray-50 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nama</th>
                            <th class="px-6 py-3 bg-gray-50 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Jenis Kelamin</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        <?php foreach ($recentStudents as $student): ?>
                        <tr>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?= htmlspecialchars($student['nis']) ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?= htmlspecialchars($student['nama_siswa']) ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                <?= $student['jenis_kelamin'] == 'L' ? 'Laki-laki' : 'Perempuan' ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php endif; ?>
    </div>
</body>
</html>
