<?php
require_once 'config/session.php';
require_once 'config/database.php';
require_once 'config/functions.php';
checkLogin();

$database = new Database();
$conn = $database->getConnection();
$currentUser = getCurrentUser();

// Get teacher details
$query = "SELECT g.*, k.nama_kelas 
          FROM guru g 
          LEFT JOIN guru_kelas gk ON g.id_guru = gk.id_guru 
          LEFT JOIN kelas k ON gk.id_kelas = k.id_kelas 
          WHERE g.id_guru = :id_guru AND gk.status = 'aktif'";
$stmt = $conn->prepare($query);
$stmt->bindParam(':id_guru', $currentUser['id_guru']);
$stmt->execute();
$teacher = $stmt->fetch(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Profil Guru - Sistem Guru Kelas SD</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body class="bg-gradient-to-br from-blue-50 to-indigo-50 min-h-screen">
    <!-- Navigation -->
       <?php require_once 'includes/navbar.php'; ?>


    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <!-- Header -->
        <div class="text-center mb-8">
            <h1 class="text-3xl font-bold text-gray-800 mb-2">Profil Guru</h1>
            <p class="text-gray-600">Kelola informasi profil Anda</p>
        </div>

        <!-- Profile Photo Section -->
        <div class="bg-white rounded-xl shadow-lg p-6 mb-6 text-center">
            <div class="w-32 h-32 bg-gradient-to-r from-indigo-500 to-purple-600 rounded-full flex items-center justify-center mx-auto mb-4 shadow-md">
                <i class="fas fa-user text-white text-5xl"></i>
            </div>
            <h2 class="text-2xl font-bold text-gray-800 mb-2"><?= htmlspecialchars($teacher['nama_guru']) ?></h2>
            <p class="text-gray-600 mb-1"><?= htmlspecialchars($teacher['email']) ?></p>
            <p class="text-sm text-gray-500 bg-gray-100 px-3 py-1 rounded-full inline-block">
                <i class="fas fa-chalkboard mr-1"></i>
                <?= htmlspecialchars($teacher['nama_kelas'] ?? 'Belum ditentukan') ?>
            </p>
        </div>

        <!-- Non-editable Information Section -->
        <div class="bg-white rounded-xl shadow-lg p-6 mb-6">
            <h3 class="text-xl font-semibold text-gray-800 mb-4 flex items-center">
                <i class="fas fa-info-circle text-indigo-600 mr-2"></i>
                Informasi Profil
            </h3>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div class="bg-gray-50 p-4 rounded-lg">
                    <label class="block text-sm font-medium text-gray-500 mb-1">NIP</label>
                    <p class="text-gray-800 font-medium"><?= htmlspecialchars($teacher['nip']) ?></p>
                </div>
                <div class="bg-gray-50 p-4 rounded-lg">
                    <label class="block text-sm font-medium text-gray-500 mb-1">Email</label>
                    <p class="text-gray-800 font-medium"><?= htmlspecialchars($teacher['email']) ?></p>
                </div>
                <div class="bg-gray-50 p-4 rounded-lg">
                    <label class="block text-sm font-medium text-gray-500 mb-1">Kelas</label>
                    <p class="text-gray-800 font-medium"><?= htmlspecialchars($teacher['nama_kelas'] ?? 'Belum ditentukan') ?></p>
                </div>
                <div class="bg-gray-50 p-4 rounded-lg">
                    <label class="block text-sm font-medium text-gray-500 mb-1">Status</label>
                    <p class="text-green-600 font-medium">Aktif</p>
                </div>
                <div class="bg-gray-50 p-4 rounded-lg">
                    <label class="block text-sm font-medium text-gray-500 mb-1">No. Telepon</label>
                    <p class="text-gray-800 font-medium"><?= htmlspecialchars($teacher['no_telp']) ?></p>
                </div>
                <div class="bg-gray-50 p-4 rounded-lg">
                    <label class="block text-sm font-medium text-gray-500 mb-1">Alamat</label>
                    <p class="text-gray-800 font-medium"><?= htmlspecialchars($teacher['alamat']) ?></p>
                </div>
            </div>
        </div>

        <!-- App Information Section -->
        <div class="bg-white rounded-xl shadow-lg p-6 mb-6">
            <h3 class="text-xl font-semibold text-gray-800 mb-4 flex items-center">
                <i class="fas fa-info-circle text-indigo-600 mr-2"></i>
                Informasi Aplikasi
            </h3>
            
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 text-center">
                <div class="bg-blue-50 p-4 rounded-lg">
                    <i class="fas fa-code text-blue-600 text-2xl mb-2"></i>
                    <h4 class="font-medium text-gray-700">Pembuat</h4>
                    <p class="text-sm text-gray-600">SultanDev</p>
                </div>
                <div class="bg-green-50 p-4 rounded-lg">
                    <i class="fas fa-code-branch text-green-600 text-2xl mb-2"></i>
                    <h4 class="font-medium text-gray-700">Versi</h4>
                    <p class="text-sm text-gray-600">1.0.0</p>
                </div>
                <div class="bg-purple-50 p-4 rounded-lg">
                    <i class="fas fa-envelope text-purple-600 text-2xl mb-2"></i>
                    <h4 class="font-medium text-gray-700">Email Pembuat</h4>
                    <p class="text-sm text-gray-600">sultan@sultan-dev.my.id</p>
                </div>
            </div>
        </div>

        <!-- Logout Button -->
        <div class="text-center">
            <a href="logout.php" 
               class="inline-flex items-center px-6 py-3 bg-red-600 text-white rounded-lg hover:bg-red-700 transition shadow-md">
                <i class="fas fa-sign-out-alt mr-2"></i>
                Logout
            </a>
        </div>
    </div>
</body>
</html>
