<?php
require_once 'config/database.php';
require_once 'config/session.php';

$error = '';
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email = $_POST['email'];
    $password = $_POST['password'];
    
    $database = new Database();
    $conn = $database->getConnection();
    
    $query = "SELECT g.*, k.id_kelas, k.nama_kelas 
              FROM guru g 
              LEFT JOIN guru_kelas gk ON g.id_guru = gk.id_guru 
              LEFT JOIN kelas k ON gk.id_kelas = k.id_kelas 
              WHERE g.email = :email AND gk.status = 'aktif' 
              ORDER BY gk.created_at DESC LIMIT 1";
    
    $stmt = $conn->prepare($query);
    $stmt->bindParam(':email', $email);
    $stmt->execute();
    
    if ($stmt->rowCount() > 0) {
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($password === $user['password']) { // Tanpa hash
            $_SESSION['id_guru'] = $user['id_guru'];
            $_SESSION['nama_guru'] = $user['nama_guru'];
            $_SESSION['email'] = $user['email'];
            $_SESSION['id_kelas'] = $user['id_kelas'];
            $_SESSION['nama_kelas'] = $user['nama_kelas'];
            
            header("Location: dashboard.php");
            exit();
        } else {
            $error = "Password salah!";
        }
    } else {
        $error = "Email tidak ditemukan atau tidak memiliki akses ke kelas!";
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Sistem Guru Kelas SD</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body class="bg-gradient-to-br from-blue-50 to-indigo-100 min-h-screen">
    <div class="flex items-center justify-center min-h-screen px-4">
        <div class="max-w-md w-full">
            <div class="bg-white rounded-2xl shadow-xl p-8">
                <div class="text-center mb-8">
                    <div class="w-20 h-20 bg-indigo-600 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-chalkboard-teacher text-white text-2xl"></i>
                    </div>
                    <h1 class="text-2xl font-bold text-gray-800">Sistem Guru Kelas SD</h1>
                    <p class="text-gray-600 mt-2">Masuk untuk mengelola kelas Anda</p>
                </div>
                
                <?php if ($error): ?>
                    <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                        <i class="fas fa-exclamation-triangle mr-2"></i><?= $error ?>
                    </div>
                <?php endif; ?>
                
                <form method="POST" class="space-y-6">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Email</label>
                        <div class="relative">
                            <i class="fas fa-envelope absolute left-3 top-3 text-gray-400"></i>
                            <input type="email" name="email" required 
                                   class="w-full pl-10 pr-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-indigo-500 focus:border-transparent"
                                   placeholder="email@guru.sd">
                        </div>
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Password</label>
                        <div class="relative">
                            <i class="fas fa-lock absolute left-3 top-3 text-gray-400"></i>
                            <input type="password" name="password" required 
                                   class="w-full pl-10 pr-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-indigo-500 focus:border-transparent"
                                   placeholder="••••••••">
                        </div>
                    </div>
                    
                    <button type="submit" 
                            class="w-full bg-indigo-600 text-white py-2 px-4 rounded-lg hover:bg-indigo-700 transition duration-200 font-medium">
                        <i class="fas fa-sign-in-alt mr-2"></i>Masuk
                    </button>
                </form>
                
                <div class="mt-6 text-center">
                    <p class="text-sm text-gray-600">
                        <strong>Demo:</strong><br>
                        Email: admin@guru.sd<br>
                        Password: admin123
                    </p>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
