<?php
function sanitizeInput($data) {
    $data = trim($data);
    $data = stripslashes($data);
    $data = htmlspecialchars($data);
    return $data;
}

function formatDate($date) {
    return date('d/m/Y', strtotime($date));
}

function getGenderText($gender) {
    return $gender == 'L' ? 'Laki-laki' : 'Perempuan';
}

function getStatusText($status) {
    $statuses = [
        'aktif' => 'Aktif',
        'lulus' => 'Lulus',
        'pindah' => 'Pindah'
    ];
    return $statuses[$status] ?? $status;
}

function getAttendanceStatusText($status) {
    $statuses = [
        'hadir' => 'Hadir',
        'sakit' => 'Sakit',
        'izin' => 'Izin',
        'alpa' => 'Alpa'
    ];
    return $statuses[$status] ?? $status;
}

function getMonthName($month) {
    $months = [
        1 => 'Januari', 2 => 'Februari', 3 => 'Maret', 4 => 'April',
        5 => 'Mei', 6 => 'Juni', 7 => 'Juli', 8 => 'Agustus',
        9 => 'September', 10 => 'Oktober', 11 => 'November', 12 => 'Desember'
    ];
    return $months[$month] ?? $month;
}
?>
