<?php
require_once 'config/session.php';
require_once 'config/database.php';
require_once 'config/functions.php';
checkLogin();

$database = new Database();
$conn = $database->getConnection();
$currentUser = getCurrentUser();

// Get task ID from URL
$id_tugas = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// Fetch task details
$task = null;
if ($id_tugas > 0) {
    try {
        $query = "SELECT t.*, m.nama_mapel, m.kode_mapel, k.nama_kelas, g.nama_guru
                  FROM tugas t 
                  JOIN mata_pelajaran m ON t.id_mapel = m.id_mapel 
                  JOIN kelas k ON t.id_kelas = k.id_kelas
                  JOIN guru g ON t.id_guru = g.id_guru
                  WHERE t.id_tugas = :id_tugas";
        
        $stmt = $conn->prepare($query);
        $stmt->bindParam(':id_tugas', $id_tugas, PDO::PARAM_INT);
        $stmt->execute();
        $task = $stmt->fetch(PDO::FETCH_ASSOC);
    } catch (PDOException $e) {
        $error = "Terjadi kesalahan: " . $e->getMessage();
    }
}

// If task not found, show error
if (!$task) {
    $error = "Tugas tidak ditemukan!";
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detail Tugas - Sistem Guru Kelas SD</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body class="bg-gray-50">
    <!-- Navigation -->
    <?php require_once 'includes/navbar.php'; ?>

    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <!-- Error Message -->
        <?php if (isset($error)): ?>
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-6" role="alert">
                <span class="block sm:inline"><?= $error ?></span>
                <a href="tugas.php" class="text-blue-600 hover:text-blue-800 ml-4">Kembali ke Daftar Tugas</a>
            </div>
        <?php endif; ?>

        <?php if ($task): ?>
            <!-- Header -->
            <div class="flex justify-between items-center mb-6">
                <div>
                    <h1 class="text-3xl font-bold text-gray-800">Detail Tugas</h1>
                    <p class="text-gray-600 mt-1">Informasi lengkap tentang tugas siswa</p>
                </div>
                <a href="tugas.php" class="bg-gray-300 text-gray-700 px-4 py-2 rounded-lg hover:bg-gray-400 transition">
                    <i class="fas fa-arrow-left mr-2"></i>Kembali
                </a>
            </div>

            <!-- Task Details Card -->
            <div class="bg-white rounded-lg shadow-md p-6 mb-6">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Basic Information -->
                    <div>
                        <h2 class="text-xl font-semibold text-gray-800 mb-4">Informasi Tugas</h2>
                        
                        <div class="space-y-3">
                            <div>
                                <span class="text-sm font-medium text-gray-600">Judul Tugas:</span>
                                <p class="text-lg font-medium text-gray-900"><?= htmlspecialchars($task['judul_tugas']) ?></p>
                            </div>
                            
                            <div>
                                <span class="text-sm font-medium text-gray-600">Mata Pelajaran:</span>
                                <p class="text-gray-900"><?= htmlspecialchars($task['nama_mapel']) ?> (<?= htmlspecialchars($task['kode_mapel']) ?>)</p>
                            </div>
                            
                            <div>
                                <span class="text-sm font-medium text-gray-600">Kelas:</span>
                                <p class="text-gray-900"><?= htmlspecialchars($task['nama_kelas']) ?></p>
                            </div>
                            
                            <div>
                                <span class="text-sm font-medium text-gray-600">Jenis Tugas:</span>
                                <p class="text-gray-900"><?= ucfirst($task['jenis']) ?></p>
                            </div>
                            
                            <div>
                                <span class="text-sm font-medium text-gray-600">Dibuat oleh:</span>
                                <p class="text-gray-900"><?= htmlspecialchars($task['nama_guru']) ?></p>
                            </div>
                            
                            <div>
                                <span class="text-sm font-medium text-gray-600">Tanggal Dibuat:</span>
                                <p class="text-gray-900"><?= formatDate($task['created_at']) ?></p>
                            </div>
                        </div>
                    </div>

                    <!-- Date Information -->
                    <div>
                        <h2 class="text-xl font-semibold text-gray-800 mb-4">Periode Tugas</h2>
                        
                        <div class="space-y-3">
                            <div>
                                <span class="text-sm font-medium text-gray-600">Tanggal Mulai:</span>
                                <p class="text-gray-900"><?= formatDate($task['tanggal_mulai']) ?></p>
                            </div>
                            
                            <div>
                                <span class="text-sm font-medium text-gray-600">Tanggal Selesai:</span>
                                <p class="text-gray-900"><?= formatDate($task['tanggal_selesai']) ?></p>
                            </div>
                            
                            <div>
                                <span class="text-sm font-medium text-gray-600">Status:</span>
                                <?php
                                $today = date('Y-m-d');
                                $status_class = '';
                                $status_text = '';
                                
                                if ($today < $task['tanggal_mulai']) {
                                    $status_class = 'bg-blue-100 text-blue-800';
                                    $status_text = 'Akan Datang';
                                } elseif ($today >= $task['tanggal_mulai'] && $today <= $task['tanggal_selesai']) {
                                    $status_class = 'bg-green-100 text-green-800';
                                    $status_text = 'Aktif';
                                } else {
                                    $status_class = 'bg-gray-100 text-gray-800';
                                    $status_text = 'Selesai';
                                }
                                ?>
                                <span class="px-3 py-1 text-sm font-medium rounded-full <?= $status_class ?>">
                                    <?= $status_text ?>
                                </span>
                            </div>
                            
                            <div>
                                <span class="text-sm font-medium text-gray-600">Durasi:</span>
                                <?php
                                $start = new DateTime($task['tanggal_mulai']);
                                $end = new DateTime($task['tanggal_selesai']);
                                $interval = $start->diff($end);
                                $days = $interval->days + 1; // Include both start and end dates
                                ?>
                                <p class="text-gray-900"><?= $days ?> hari</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Description -->
                <div class="mt-6 pt-6 border-t border-gray-200">
                    <h2 class="text-xl font-semibold text-gray-800 mb-4">Deskripsi Tugas</h2>
                    <div class="bg-gray-50 rounded-lg p-4">
                        <?php if (!empty($task['deskripsi'])): ?>
                            <p class="text-gray-800 whitespace-pre-wrap"><?= htmlspecialchars($task['deskripsi']) ?></p>
                        <?php else: ?>
                            <p class="text-gray-500 italic">Tidak ada deskripsi tambahan</p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="flex justify-end space-x-3">
                <a href="edit_tugas.php?id=<?= $task['id_tugas'] ?>" class="bg-green-600 text-white px-4 py-2 rounded-lg hover:bg-green-700 transition">
                    <i class="fas fa-edit mr-2"></i>Edit Tugas
                </a>
                <button onclick="deleteTask(<?= $task['id_tugas'] ?>)" class="bg-red-600 text-white px-4 py-2 rounded-lg hover:bg-red-700 transition">
                    <i class="fas fa-trash mr-2"></i>Hapus Tugas
                </button>
            </div>
        <?php endif; ?>
    </div>

    <script>
        function deleteTask(id) {
            if (confirm('Apakah Anda yakin ingin menghapus tugas ini?')) {
                window.location.href = 'delete_tugas.php?id=' + id;
            }
        }
    </script>
</body>
</html>
