<?php
require_once 'config/session.php';
require_once 'config/database.php';
checkLogin();

$database = new Database();
$conn = $database->getConnection();

// Get student ID from URL
$id_siswa = isset($_GET['id']) ? $_GET['id'] : die('ERROR: Student ID not found.');

// Fetch student details
$query = "SELECT * FROM siswa WHERE id_siswa = :id_siswa";
$stmt = $conn->prepare($query);
$stmt->bindParam(':id_siswa', $id_siswa);
$stmt->execute();
$student = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$student) {
    die('ERROR: Student not found.');
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detail Siswa - SIMAGU</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body class="bg-gray-50">
    <?php require_once 'includes/navbar.php'; ?>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <div class="flex justify-between items-center mb-6">
            <h1 class="text-3xl font-bold text-gray-800">Detail Siswa</h1>
            <div class="flex space-x-2">
                <a href="edit_siswa.php?id=<?= $student['id_siswa'] ?>" class="bg-green-600 text-white px-4 py-2 rounded-lg hover:bg-green-700 transition">
                    <i class="fas fa-edit mr-2"></i>Edit
                </a>
            </div>
        </div>

        <!-- Student Details Card -->
        <div class="bg-white rounded-lg shadow-md overflow-hidden">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 p-6">
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-500 mb-1">NIS</label>
                        <p class="text-lg font-semibold text-gray-800"><?= htmlspecialchars($student['nis']) ?></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-500 mb-1">Nama Lengkap</label>
                        <p class="text-lg font-semibold text-gray-800"><?= htmlspecialchars($student['nama_siswa']) ?></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-500 mb-1">Jenis Kelamin</label>
                        <p class="text-lg font-semibold text-gray-800">
                            <?= $student['jenis_kelamin'] == 'L' ? 'Laki-laki' : 'Perempuan' ?>
                        </p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-500 mb-1">Tanggal Lahir</label>
                        <p class="text-lg font-semibold text-gray-800">
                            <?= date('d F Y', strtotime($student['tanggal_lahir'])) ?>
                        </p>
                    </div>
                </div>
                
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-500 mb-1">Alamat</label>
                        <p class="text-lg text-gray-800"><?= htmlspecialchars($student['alamat']) ?></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-500 mb-1">Nama Orang Tua</label>
                        <p class="text-lg text-gray-800"><?= htmlspecialchars($student['nama_ortu']) ?></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-500 mb-1">No. Telepon Orang Tua</label>
                        <p class="text-lg text-gray-800"><?= htmlspecialchars($student['no_telp_ortu']) ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
